;---------------------------------------------------
;  _____  _____ _   _                 _       _____ _      _____ _             _ _
; |_   _|/ ____| \ | |     /\        | |     |_   _| |    / ____| |           | (_)
;   | | | (___ |  \| |    /  \  _   _| |_ ___  | | | |_  | (___ | |_ _   _  __| |_  ___
;   | |  \___ \| . ` |   / /\ \| | | | __/ _ \ | | | __|  \___ \| __| | | |/ _` | |/ _ \
;  _| |_ ____) | |\  |  / ____ \ |_| | || (_) || |_| |_   ____) | |_| |_| | (_| | | (_) |
; |_____|_____/|_| \_| /_/    \_\__,_|\__\___/_____|\__| |_____/ \__|\__,_|\__,_|_|\___/
;
;
; by ISI360 (Christian Faderl)
;---------------------------------------------------

;Versions Info
Global Const $VersionBuild = "20240507" ;YEAR|MON|DAY
Global Const $Studioversion = "1.16"
Global Const $ERSTELLUNGSTAG = "07.05.2024 (" & $VersionBuild & ")"

;Autoit Wrapper
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
	#AutoIt3Wrapper_Res_Description=ISN AutoIt Studio
	#AutoIt3Wrapper_Res_Fileversion=1.0.16
	#AutoIt3Wrapper_Res_ProductVersion=1.16
	#AutoIt3Wrapper_Res_LegalCopyright=ISI360
	#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
	#AutoIt3Wrapper_Res_Field=ProductName|ISN AutoIt Studio
	#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
	#AutoIt3Wrapper_UseUpx=n
	#AutoIt3Wrapper_Run_Tidy=y
	#AutoIt3Wrapper_Res_HiDpi=Y
	#AutoIt3Wrapper_Run_AU3Check=Y
	#AutoIt3Wrapper_Outfile_type=a3x
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

;Set Res_HiDpi (required for HighDpi a3x)
DllCall("User32.dll", "bool", "SetProcessDPIAware")

;Autoit Options
#NoTrayIcon
Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 1) ;Can close every GUI with ESC
Opt("WinTextMatchMode", 1) ;1=complete, 2=quick
Opt("WinTitleMatchMode", 3) ;1=start, 2=subStr, 3=exact, 4=advanced, -1 to -4=Nocase
Opt("GUIResizeMode", 802)

;Ensure correct working directory
FileChangeDir(@ScriptDir)

;AutoIt Includes
#include <APIConstants.au3>
#include <Array.au3>
#include <ButtonConstants.au3>
#include <ClipBoard.au3>
#include <Color.au3>
#include <ComboConstants.au3>
#include <Constants.au3>
#include <Crypt.au3>
#include <Date.au3>
#include <EditConstants.au3>
#include <file.au3>
#include <FileConstants.au3>
#include <FontConstants.au3>
#include <GDIPlus.au3>
#include <GuiButton.au3>
#include <GUIComboBox.au3>
#include <GUIConstants.au3>
#include <GUIConstantsEx.au3>
#include <GuiDateTimePicker.au3>
#include <GuiEdit.au3>
#include <GuiImageList.au3>
#include <GUIListBox.au3>
#include <GuiListView.au3>
#include <GuiMenu.au3>
#include <GuiReBar.au3>
#include <GuiRichEdit.au3>
#include <GuiScrollBars.au3>
#include <GuiSlider.au3>
#include <GuiStatusBar.au3>
#include <GuiTab.au3>
#include <GuiToolbar.au3>
#include <GuiToolTip.au3>
#include <GuiTreeView.au3>
#include <IE.au3>
#include <Inet.au3>
#include <InetConstants.au3>
#include <Math.au3>
#include <Memory.au3>
#include <Misc.au3>
#include <Process.au3>
#include <ProgressConstants.au3>
#include <ScrollBarsConstants.au3>
#include <SendMessage.au3>
#include <Sound.au3>
#include <StaticConstants.au3>
#include <String.au3>
#include <StructureConstants.au3>
#include <TabConstants.au3>
#include <Timers.au3>
#include <TreeViewConstants.au3>
#include <WinAPI.au3>
#include <WinAPIDlg.au3>
#include <WinAPIEx.au3>
#include <WinAPILocale.au3>
#include <WinAPISys.au3>
#include <WindowsConstants.au3>

;Initialize Microsoft Windows GDI+
_GDIPlus_Startup()

;Custom ISN Includes 1/2
#include "includes\ISN_UDF_GUIRegisterMsg20.au3"
#include "includes\ISN_UDF_RDC.au3"
#include "includes\ISN_Addon_Scintilla_Pixmaps.au3"
#include "includes\ISN_UDF_iniEx.au3"
#include "includes\ISN_UDF_ZLIB.au3"
#include "includes\ISN_UDF_IniVirtual.au3"
#include "includes\ISN_Studio_Declarations.au3"
#include "includes\ISN_UDF_Icons.au3"
#include "includes\ISN_UDF_AdlibEnhance.au3"
#include "includes\ISN_Addon_DPI_Scaling.au3"
#include "includes\ISN_UDF_Scintilla_Declarations.au3"
#include "Includes\ISN_UDF_EasyHotKey.au3"
#include "includes\ISN_UDF_RunWithReducedPrivileges.au3"
#include "includes\ISN_UDF_Curl.au3"
#include "includes\ISN_UDF_USkin.au3"
#include "includes\ISN_UDF_Copy.au3"
#include "includes\ISN_UDF_Zip32.au3"
#include "includes\ISN_UDF_AcInput.au3"
#include "includes\ISN_UDF_GUIScrollbars_Ex.au3"
#include "includes\ISN_UDF_ChatBox.au3"
#include "includes\ISN_Addon_DebugConsole.au3"
#include "includes\ISN_UDF_ModernMenuRaw.au3"
#include "includes\ISN_UDF_Json.au3"
#include "includes\ISN_UDF_TristateTreeViewLib.au3"
#include "includes\ISN_UDF_SciLexer.au3"
#include "includes\ISN_UDF_ColorChooser.au3"
#include "includes\ISN_UDF_TVExplorer.au3"

;Some Forms and Includes for the startup sequence
#include "Forms\ISN_StartupLogo.isf"
#include "Forms\ISN_Update_wird_Abgeschlossen.isf"

;Get available displays (This fills $__MonitorList)
_GetMonitors()

;First check of /silentreorganisation
;Used from the installer after an upgrade installation
If IsArray($CmdLine) Then
	For $x = 1 To $CmdLine[0]
		If StringInStr($CmdLine[$x], "/silentreorganisation") Then
			_ISN_AutoIt_Studio_Dateien_und_Ordner_reorganisieren()
			Exit
		EndIf
	Next
EndIf

;Check, if the ISN should always be started as Admin
_CheckIfISNShouldRunAsAdmin()

;Initialize USkin UDF and apply a skin (if enabled)
_Uskin_LoadDLL(@ScriptDir & "\Data\USkin.dll")
If Not FileExists(@ScriptDir & "\Data\Skins\" & $skin) Then $skin = "#none#"
$pfad = @ScriptDir & "\Data\Skins\" & $skin & "\skin.msstyles"
If $skin <> "#none#" Then
	_USkin_Init($pfad) ;Apply skin
EndIf

;Check if there is another ISN AutoIt Studio instance running. If yes, submit the filepath to the running instance.
If $CmdLine[0] > 0 Then
	Opt("WinTitleMatchMode", 2)
	Opt("WinDetectHiddenText", 1)
	Global $Other_Studio_Handle = WinGetHandle("[TITLE:ISN AutoIt Studio; CLASS:AutoIt v3 GUI]", "ISN_MAIN_GUI")
	If Not @error Then
		For $parameter_count = 1 To $CmdLine[0]
			If StringInStr($CmdLine[$parameter_count], ".icp") And Not StringInStr($CmdLine[$parameter_count], "/") Then
				_ISN_Send_Message_to_Plugin($Other_Studio_Handle, "callfunc_in_ISN" & $Plugin_System_Delimiter & "_Import_ICP_Plugin_CMD" & $Plugin_System_Delimiter & FileGetLongName($CmdLine[$parameter_count]), 1)
				WinActivate($Other_Studio_Handle)
				Exit
			EndIf

			If StringInStr($CmdLine[$parameter_count], ".isn") And Not StringInStr($CmdLine[$parameter_count], "/") Then
				$Other_Studio_Handle = WinGetHandle("[TITLE:" & IniRead($CmdLine[$parameter_count], "ISNAUTOITSTUDIO", "name", "") & " - ISN AutoIt Studio; CLASS:AutoIt v3 GUI]", "ISN_MAIN_GUI")
				$StudioFenster = $console_GUI ;Make the debug console temp to the studiofenster..for recieving plugin messages
				GUIRegisterMsg(0x004A, "_ISN_Studio_Message_Handler")
				If String(_ISN_ExecuteInOtherISNSession($Other_Studio_Handle, "$Pfad_zur_Project_ISN")) = String(FileGetLongName($CmdLine[$parameter_count])) Then
					WinActivate($Other_Studio_Handle) ;There is already a session with this project
					Exit
				EndIf
				GUIRegisterMsg(0x004A, "")
				$StudioFenster = ""
			EndIf
		Next
	EndIf
	Opt("WinTitleMatchMode", 3)
	$Editormode_Studio_Handle = WinGetHandle(_Get_langstr(1) & " - " & _Get_langstr(661), "ISN_MAIN_GUI")
	If Not @error Then
		For $parameter_count = 1 To $CmdLine[0]
			If StringInStr($CmdLine[$parameter_count], ".au3") And Not StringInStr($CmdLine[$parameter_count], "/") Then _ISN_Send_Message_to_Plugin($Editormode_Studio_Handle, "callfunc_in_ISN" & $Plugin_System_Delimiter & "_Try_to_open_file" & $Plugin_System_Delimiter & FileGetLongName($CmdLine[$parameter_count]), 1)
		Next
		WinActivate($Editormode_Studio_Handle)
		Exit
	EndIf
	Opt("WinDetectHiddenText", 0)
EndIf

;Set proxy server
_Set_Proxyserver()

;Check if the ISN has been started from a compressed drive. If yes, a warning will be shown.
If StringInStr(FileGetAttrib(StringTrimRight(@AutoItExe, StringLen(@AutoItExe) - StringInStr(@AutoItExe, "\"))), "C") Then
	$res = MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(442), 0)
	If $res = 7 Then Exit
EndIf


;Check encoding settings (legacy stuff for old ISN versions)
If IniRead($Configfile, "warnings", "confirmencoding", "0") = "0" And $autoit_editor_encoding = "1" Then
	$antwort = MsgBox(4 + 48 + 262144, _Get_langstr(394), _Get_langstr(1137), 0)
	If @error Or $antwort = 7 Then
		IniWrite($Configfile, "warnings", "confirmencoding", "1")
	EndIf

	If $antwort = 6 Then
		_Write_in_Config("autoit_editor_encoding", "2")
		IniWrite($Configfile, "warnings", "confirmencoding", "1")
		$autoit_editor_encoding = "2"
	EndIf
EndIf

;Show the ISN AutoIt Studio startup Logo (if enabled)
GUIRegisterMsg($WM_NCHITTEST, "WM_NCHITTEST")
GUIRegisterMsg($WM_WINDOWPOSCHANGING, "WM_WINDOWPOSCHANGING_STARTUP") ;Register Boot WINDOWPOSCHANGING
GUIRegisterMsg($WM_NCACTIVATE, "_WM_NCACTIVATE_Startup")
GUICtrlSetData($startup_text, _Get_langstr(461))
WinSetTrans($ISN_StartupLogoGUI, "", 0)
If _ist_windows_vista_oder_hoeher() And $Skin_is_used = "false" Then
	GUIRegisterMsg($WM_NCCALCSIZE, "WM_NCCALCSIZE")
	_WinAPI_DwmExtendFrameIntoClientArea($ISN_StartupLogoGUI, _WinAPI_CreateMargins(0, 0, 0, 1)) ;to enable drop shadow
Else
	GUISetStyle($WS_POPUP, $WS_EX_TOOLWINDOW, $ISN_StartupLogoGUI) ;Legacy style for pre-vista OS
EndIf
_WinAPI_SetWindowPos($ISN_StartupLogoGUI, Null, 0, 0, 477 * $DPI, 284 * $DPI, $SWP_NOZORDER + $SWP_NOOWNERZORDER + $SWP_NOMOVE + $SWP_FRAMECHANGED)
_CenterOnMonitor($ISN_StartupLogoGUI, "", _ISN_Gui_Size_Saving_Get_Gui_Monitor_by_Keyname("mainwindow"))
GUISetState(@SW_SHOW, $ISN_StartupLogoGUI)
If $enablelogo = "true" Then
	$alpha = 0
	While 1
		Sleep(1)
		$alpha = $alpha + 15
		If $alpha > 255 Then
			$alpha = 255
			ExitLoop
		EndIf
		WinSetTrans($ISN_StartupLogoGUI, "", $alpha)
	WEnd
	WinSetTrans($ISN_StartupLogoGUI, "", 255)
Else
	GUISetState(@SW_HIDE, $ISN_StartupLogoGUI)
EndIf

;Show the ISN debug console (if enabled)
_ISN_Gui_Size_Saving_Restore_Settings_by_Keyname("debugconsole")
_Resize_Debug_Console()
If $SHOW_DEBUG_CONSOLE = "true" Then
	_EasyHotKey_RegisterFuncForDebugLogs("_ISN_HotkeyUDFRecieveLogs")
	GUISetState(@SW_SHOW, $console_GUI)
EndIf

;Set startup progress
GUICtrlSetData($startup_progress, 10)
_Write_ISN_Debug_Console("Welcome to the ISN AutoIt Studio version " & $Studioversion & " (build " & $VersionBuild & ")" & "!", 0)
If $Save_Mode = "true" Then _Write_ISN_Debug_Console("SAFEMODE IS ACTIVE!", 3, 1, 1, 1)
_Write_ISN_Debug_Console("ISN AutoIt Studio starting up...", 1)


;Check if the ISN is already configured. If not, show the "initial setup" screen
#include "Forms\ISN_Ersteinrichtung_Sprache.isf"
If Not FileExists(RegRead("HKEY_CURRENT_USER\Software\ISN AutoIt Studio", "Configfile")) And FileExists(@ScriptDir & "\portable.dat") = 0 Then
	_Load_Languages()
	GUISetState(@SW_HIDE, $ISN_StartupLogoGUI)
	GUISetState(@SW_SHOW, $Sprache_Ersteinrichtung_GUI)
	While 1
		$state = WinGetState($Sprache_Ersteinrichtung_GUI, "")
		$i = 0
		If BitAND($state, 2) Then $i = 1
		If $i = 0 Then ExitLoop
		Sleep(200)
	WEnd
EndIf
#include "includes\ISN_Studio_Firstconfig.au3"
If Not FileExists(RegRead("HKEY_CURRENT_USER\Software\ISN AutoIt Studio", "Configfile")) And FileExists(@ScriptDir & "\portable.dat") = 0 Then _Show_Firstconfig()

;Convert the ISN config.ini to UTF-16 (LE) encoding (legacy stuff for old ISN versions)
_Datei_nach_UTF16_konvertieren($Configfile, "false")

;Initialize the ISN AcInput-UDF
_AcInputUDF_Initialize("_AcInputUDF_CallbackFunc")

;"After update" area (if the ISN was started with the "/finishupdate" parameter)
;Try to keep the isn directory clean. Delete old files that aren´t needed anymore.
_ISN_AutoIt_Studio_Dateien_und_Ordner_reorganisieren()
If IsArray($CmdLine) Then
	For $x = 1 To $CmdLine[0]
		;/finishupdate
		If StringInStr($CmdLine[$x], "/finishupdate") Then
			GUISetState(@SW_HIDE, $console_GUI)
			GUISetState(@SW_HIDE, $ISN_StartupLogoGUI)
			GUISetState(@SW_SHOW, $Update_wird_Abgeschlossen_GUI)
			Sleep(500)
			If _ISN_Update_Installer_aus_Package_installieren() <> 1 Then MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1332), 0) ;Selfeupdate for the integrated update installer
			Sleep(1000)
			_RunWithReducedPrivileges(@ScriptDir & "\Autoit_Studio.exe", '', @ScriptDir)
			_USkin_Exit()
			Exit
		EndIf
	Next
EndIf

;Command line for .isn files
Global $CommandLine = ""
If $CmdLine[0] > 1 Then
	Global $CommandLine = $CmdLine[2]
	FileChangeDir(@ScriptDir)
EndIf

;Check and create ISN Working directories
If Not FileExists($Arbeitsverzeichnis) Then DirCreate($Arbeitsverzeichnis)
If Not FileExists($Arbeitsverzeichnis & "\Data\Cache") Then DirCreate($Arbeitsverzeichnis & "\Data\Cache")
If Not FileExists($Arbeitsverzeichnis & "\Data\Api") Then DirCreate($Arbeitsverzeichnis & "\Data\Api")
If Not FileExists($Arbeitsverzeichnis & "\Data\Properties") Then DirCreate($Arbeitsverzeichnis & "\Data\Properties")
If Not FileExists(_ISN_Variablen_aufloesen($Projectfolder)) Then DirCreate(_ISN_Variablen_aufloesen($Projectfolder))
If Not FileExists(_ISN_Variablen_aufloesen($templatefolder)) Then DirCreate(_ISN_Variablen_aufloesen($templatefolder))
If Not FileExists(_ISN_Variablen_aufloesen($Standardordner_UDFs)) Then DirCreate(_ISN_Variablen_aufloesen($Standardordner_UDFs))

;Write current Languagefile to the registry (for plugins)
RegWrite("HKEY_CURRENT_USER\Software\ISN AutoIt Studio", "plugin_language", "REG_SZ", $Languagefile)

;Transfer the additional include paths from the ISN AutoIt Studio to the windows registry (if enabled)
_Pfade_fuer_Weitere_Includes_in_Registrierung_uebernehmen()

;Set startup progress
GUICtrlSetData($startup_progress, 20)

;Get the resolution of the current display
$Monitor_Aufloesung = _Get_Monitor_Resolution($Runonmonitor)
If $Monitor_Aufloesung[0] = "" Then
	$Monitor_Aufloesung[0] = @DesktopWidth
	$Monitor_Aufloesung[1] = @DesktopHeight
EndIf

;Let´s create the main window for the ISN AutoIt Studio
;This Form is seperated in logical extracode controls, for better organisation.
#include "Forms\ISN_AutoIt_Studio_Mainwindow.isf"


;Set startup progress
GUICtrlSetData($startup_progress, 30)

;Check if save mode is activated. In safe mode, all ISN plugins are disabled.
;If not, list and load all installed ISN plugins
If $Save_Mode = "false" Then
	GUICtrlSetData($startup_text, _Get_langstr(463))
	_Write_ISN_Debug_Console("|--> Loading Plugins...", 1, 0)
	_Plugins_ordner_pruefen()
	_Load_Plugins()
	_Write_ISN_Debug_Console("done", 1, 1, 1, 1)
	GUICtrlSetData($startup_progress, 80)
Else
	_Write_ISN_Debug_Console("|--> Loading Plugins...", 1, 0)
	_Write_ISN_Debug_Console("ERROR (SAFEMODE)", 3, 1, 1, 1)
EndIf


;Set startup progress
GUICtrlSetData($startup_text, _Get_langstr(462))
GUICtrlSetData($startup_progress, 40)

;Custom ISN Includes 2/2
_Write_ISN_Debug_Console("|--> Loading GUIs...", 1, 0)
#include "includes\ISN_Studio_Forms.au3"
#include "includes\ISN_Addon_Projectmanager.au3"
#include "includes\ISN_Addon_Macros.au3"
#include "includes\ISN_Addon_Macroeditor.au3"
#include "includes\ISN_Studio_Settings.au3"
#include "includes\ISN_Addon_Credits.au3"
#include "includes\ISN_Studio_Addons.au3"
#include "includes\ISN_Shared_Addons.au3"
#include "includes\ISN_Addon_UDFManager.au3"
#include "includes\ISN_Studio_WindowMessages.au3"
#include "includes\ISN_Addon_Projectsettings.au3"
#include "includes\ISN_Addon_Scintilla_Editor.au3"
#include "includes\ISN_Addon_Pluginsystem.au3"
#include "includes\ISN_Addon_Trophies.au3"
#include "includes\ISN_UDF_PDH_PerformanceCounters.au3"
#include "includes\ISN_UDF_WinTimeFunctions.au3" ; needed for certain value adjustments in retrieving Counter Values
#include "includes\ISN_UDF_WinAPI_GetSystemInfo.au3" ; _WinAPI_GetSystemInfo_ISN(6) -> CPU count
#include "includes\ISN_UDF_PDH_ObjectBaseCounters.au3"
#include "includes\ISN_UDF_PDH_ProcessCounters.au3"
#include "includes\ISN_Addon_AutoItObfuscator_WebAPI.au3"
_Write_ISN_Debug_Console("done", 1, 1, 1, 1)

;If the ISN is in portable mode, auto-detect certain paths at every startup (like the path to autoit3.exe)
If FileExists(@ScriptDir & "\portable.dat") Or $Pfade_bei_Programmstart_automatisch_suchen = "true" Then
	_Automatische_Suche_der_AutoIt_Ordner()
EndIf
;Restore the lfast window size and postion of the mainwindow (if enabled)
_ISN_Gui_Size_Saving_Restore_Settings_by_Keyname("mainwindow")

;Initialize the Performance Counters UDF
_PDH_Init()

;Register filetypes that are used by the ISN in the windows registry
_ISN_Register_Filetypes()

;If there is a program specified that sould run before the isn starts up, run that now
If $runbefore <> "" Then
	GUICtrlSetData($startup_text, _Get_langstr(404))
	_Write_ISN_Debug_Console("|--> Run before start...", 1, 0)
	_Run_Beforstart()
	_Write_ISN_Debug_Console("done", 1, 1, 1, 1)
EndIf

;Load projects in the project folder
GUICtrlSetData($startup_text, _Get_langstr(464))
_Load_Projectlist()
GUICtrlSetData($startup_progress, 80)

;Check if Autoit3.exe exists
If Not FileExists($autoitexe) Then MsgBox(262144 + 48, _Get_langstr(394), _Get_langstr(1461), 0, $ISN_StartupLogoGUI)

;Run needed helper threads
GUIRegisterMsg(0x004A, "_ISN_Studio_Message_Handler") ;Register _WM_COPYDATA für Plugins
GUICtrlSetData($startup_text, _Get_langstr(1342))
_Write_ISN_Debug_Console("|--> Starting needed ISN helper threads...", 1)
_ISN_AutoIt_Studio_start_Scripttree_Helper_Thread()
Sleep(1000) ;Give helper some time to start...
GUICtrlSetData($startup_progress, 100)
GUICtrlSetData($startup_text, _Get_langstr(23))


;Convert the "Default Templates" to UTF-16 (legacy stuff for old ISN versions)
If FileExists(_ISN_Variablen_aufloesen($templatefolder & "\default")) Then
	$Template_Projektdatei = _Finde_Projektdatei(_ISN_Variablen_aufloesen($templatefolder & "\default"))
	If FileExists($Template_Projektdatei) Then _Datei_nach_UTF16_konvertieren($Template_Projektdatei, "false")
EndIf

;Initialize the RDC (Read Directory Changes) UDF
_Write_ISN_Debug_Console("|--> Loading RDC DLL...", 1, 0)
_RDC_OpenDll()
If @error Then
	_Write_ISN_Debug_Console("ERROR (CODE: " & @error & ")", $ISN_Debug_Console_Errorlevel_Critical, 1, 1, 1)
Else
	_Write_ISN_Debug_Console("done", 1, 1, 1, 1)
EndIf


;Draw the QuickView Area
_QuickView_Refresh_Layout()

;Register WTS Session Notification (used for redrawing the gui when locking/unlocking the session)
DllCall("Wtsapi32.dll", "int", "WTSRegisterSessionNotification", "hwnd", $Studiofenster, "dword", $NOTIFY_FOR_THIS_SESSION)

;Registriere and activate Gui Message handlers
_ISN_AutoIt_Studio_activate_GUI_Messages()

;Restore positions and states of all isn guis (if enabled)
_ISN_Gui_Size_Saving_Restore_All_GUI_Settings()
If $fullscreenmode = "true" Then _Toggle_Fulscreen()

;Restore the position of the splitter controls in the main gui
$size1 = _WinGetClientSize($StudioFenster, "")
GUICtrlSetPos($Middle_Splitter_Y, 268, ($size1[1] / 100) * Number(_Config_Read("Middle_Splitter_Y", $Mittlerer_Splitter_Y_default)))
GUICtrlSetPos($Left_Splitter_Y, 2, ($size1[1] / 100) * Number(_Config_Read("Left_Splitter_Y", $Linker_Splitter_Y_default)))
GUICtrlSetPos($Left_Splitter_X, ($size1[0] / 100) * Number(_Config_Read("Left_Splitter_X", $Linker_Splitter_X_default)))
GUICtrlSetPos($Right_Splitter_X, ($size1[0] / 100) * Number(_Config_Read("Right_Splitter_X", $Rechter_Splitter_X_default)))
If $Scripteditor_DualEditorView = "vertical" Then
	GUICtrlSetPos($Splitter_DualEditor, ($size1[0] / 100) * Number(_Config_Read("Dual_Splitter_Vertical", $Splitter_DualEditor_DefaultVertical)))
Else
	GUICtrlSetPos($Splitter_DualEditor, 2, ($size1[1] / 100) * Number(_Config_Read("Dual_Splitter_Horizontal", $Splitter_DualEditor_DefaultHorizontal)))
EndIf

;Some risizing and startup stuff
_GUICtrlStatusBar_Resize($Status_bar)
_GUICtrlStatusBar_SetIcon($Status_bar, 1, _WinAPI_ShellExtractIcon($smallIconsdll, 913, 16, 16))
If $ISN_Dark_Mode = "true" Then _GUICtrlStatusBar_SetBkColor($Status_bar, 0x626262)
_HIDE_FENSTER_RECHTS("true") ;Verstecke Skriptbaumbbb
_HIDE_FENSTER_UNTEN("true") ;Verstecke Debugfenster
$tpos = _ControlGetPos($StudioFenster, "", $htab)
GUICtrlSetPos($HD_Logo, $tpos[0] + ($tpos[2] / 2) - 200, $tpos[1] + ($tpos[3] / 2) - 200, 400, 400)
GUICtrlSetState($HD_Logo, $GUI_SHOW)
_WinAPI_SetWindowLong($ISN_StartupLogoGUI, $GWL_HWNDPARENT, $Welcome_GUI)
_Aktualisiere_Splittercontrols()
_Rezize()
_Elemente_an_Fesntergroesse_anpassen_Startup()
_QuickView_Tab_Event()
_QuickView_GUI_Resize()
_Write_ISN_Debug_Console("|--> ISN AutoIt Studio startup successfully! ;)", 1)
_Write_ISN_Debug_Console("", 0)


;Finally, show the main gui ($Studiofenster)
GUISetState(@SW_DISABLE, $StudioFenster)
Switch $ISN_Save_Positions_mode

	Case "0"
		;mode 0: no position or size saving. Just center and maximize it
		GUISetState(@SW_MAXIMIZE, $StudioFenster)

	Case "1", "2"
		;mode 1: if no position is found, maximize it. Otherwise simply show the window
		If IniRead($Configfile, "positions", "mainwindow", "") = "" Then
			GUISetState(@SW_MAXIMIZE, $StudioFenster)
		Else
			GUISetState(@SW_SHOW, $StudioFenster)
		EndIf


EndSwitch
GUISetState(@SW_SHOWNOACTIVATE, $QuickView_GUI)

;Update Statusbar size
_Status_bar_aktualisiere_Parts()
_WinAPI_RedrawWindow($StudioFenster, 0, 0, BitOR($RDW_ERASE, $RDW_INVALIDATE, $RDW_ALLCHILDREN))


;If the isn was started with files to open as parameter
If $CmdLine[0] = 1 Then
	_ISN_Hide_StartupLogo()
	If StringInStr($CmdLine[1], "." & $Autoitextension) Then _oeffne_Editormodus(FileGetLongName($CmdLine[1]))
	If StringInStr($CmdLine[1], ".isn") Then _Load_Project_by_Foldername(FileGetLongName(StringTrimRight($CmdLine[1], StringLen($CmdLine[1]) - StringInStr($CmdLine[1], "\", 0, -1) + 1)))
	If StringInStr($CmdLine[1], ".isp") Then _Import_Project_CMD($CmdLine[1])
	If StringInStr($CmdLine[1], ".icp") Then _Import_ICP_Plugin_CMD($CmdLine[1])
EndIf

If $CmdLine[0] = 2 Then
	If StringInStr($CmdLine[2], "." & $Autoitextension) Then _oeffne_Editormodus(FileGetLongName($CmdLine[2]))
EndIf

If $CommandLine = "" And $CmdLine[0] <> 1 Then
	If $Autoload = "true" And Not $LastProject = "" And FileExists(_ISN_Variablen_aufloesen($LastProject)) Then
		_ISN_Hide_StartupLogo()
		If _ISN_Variablen_aufloesen($LastProject) = $Arbeitsverzeichnis & "\Data\Editormode" Then
			_oeffne_Editormodus("")
		Else
			_Load_Project_by_Foldername(_ISN_Variablen_aufloesen($LastProject))
		EndIf
	Else
		GUISetState(@SW_SHOW, $Welcome_GUI)
		WinActivate($Welcome_GUI)
	EndIf
Else
	If StringTrimLeft($CommandLine, StringInStr($CommandLine, ".", 0, -1)) = "isn" Then
		_ISN_Hide_StartupLogo()
		$tempp = IniReadSection($CommandLine, "ISNAUTOITSTUDIO")
		If @error Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(476), 0, $StudioFenster)
			GUISetState(@SW_SHOW, $Welcome_GUI)
			WinActivate($Welcome_GUI)
		Else
			$CommandLine = FileGetLongName(StringTrimRight($CommandLine, StringLen($CommandLine) - StringInStr($CommandLine, "\", 0, -1) + 1))
			_show_Loading(_Get_langstr(34), _Get_langstr(23))
			_Loading_Progress(30)
			_Load_Project($CommandLine)
			$History_Projekte_Array = _fuege_in_History_ein($History_Projekte_Array, $CommandLine)
			_Loading_Progress(100)
			GUISetState(@SW_ENABLE, $StudioFenster)
			_Hide_Loading()
			_Check_tabs_for_changes()
		EndIf
	EndIf

	If StringTrimLeft($CommandLine, StringInStr($CommandLine, ".", 0, -1)) = "isp" Then
		_ISN_Hide_StartupLogo()
		_Show_Projectman()
		_Import_project($CommandLine)
	EndIf
EndIf


;Count startups of the ISN AutoIt Studio
$startups = Number(IniRead($Configfile, "config", "startups", 0))
IniWrite($Configfile, "config", "startups", $startups + 1)
If $startups > 149 Then _Earn_trophy(8, 2)

;Cleanup process ram usage, after startup
_Adlib_ISN_Ram_bereinigen()
AdlibRegister("_Adlib_ISN_Ram_bereinigen", _Config_Read("isn_cleanup_memory_after_ms", 1800000)) ;Alle 30 Minuten RAM bereinigen

;Register "watchdog" for isn helper threads
AdlibRegister("_ISN_Helper_Thread_Adlib", 500) ;Prüft alle 500ms zwecks Helper Nachrichten

;Activate hotkeys and the hotkey UDF
_EasyHotKey_Initialize(BitOR($EasyHotKey_InitializeKeyboard, $EasyHotKey_InitializeMouse), "_EasyHotKey_KeyboardCallback", "_ISN_EasyHotKey_MouseCallback")
_ISN_aktualisiere_Hotkeys()

;Hide startup logo
_Fadeout_logo()

;Set timer for checking for online updates
$Auto_Update_Timer_Handle = _Timer_SetTimer($StudioFenster, 60000, "_Pruefe_nach_Onlineupdates_AUTO") ;nach 1 min prüfe online Update

;The main while loop of the program
While 1

	;Check hover on hyperlinks in the project settings
	$Projekteinstellungen_GUI_WinState = WinGetState($Projekteinstellungen_GUI, "")
	If BitAND($Projekteinstellungen_GUI_WinState, 2) Then _Projekteinstellungen_Hyperlinks_preufen()

	;Check hover on hyperlinks in the info gui
	$ISN_Ueber_GUI_WinState = WinGetState($ISN_Ueber_GUI, "")
	If BitAND($ISN_Ueber_GUI_WinState, 2) Then _Info_GUI_Check_Hyperlinks()

	;Check hover on hyperlinks in the settings gui
	$config_GUI_WinState = WinGetState($config_GUI, "")
	If BitAND($config_GUI_WinState, 2) Then _Config_GUI_Check_Hyperlinks()


	Global $size1 = _WinGetClientSize($StudioFenster, "")
	Global $size = _WinGetPos($StudioFenster)


	If _GUICtrlTab_GetItemCount($htab) > 0 And _GUICtrlTab_GetCurFocus($htab) <> -1 And IsDeclared("hTab") And $Offenes_Projekt <> "" Then

		If _GUICtrlTab_GetItemCount($htab) > 0 Then
			$statet = WinGetState($StudioFenster, "")
			If BitAND($statet, 4) Then
				GUISetState(@SW_ENABLE, $QuickView_GUI)
			Else
				GUISetState(@SW_DISABLE, $QuickView_GUI)
			EndIf

			If _hit_win(_WinAPI_GetFocus()) And _WinAPI_GetClassName(_WinAPI_GetFocus()) = "Scintilla" And BitAND($statet, 2) Then
				GUIRegisterMsg($WM_CONTEXTMENU, "WM_CONTEXTMENU_EDITOR")
			Else
				GUIRegisterMsg($WM_CONTEXTMENU, "")
				If Not _hit_win(_WinAPI_GetFocus()) Then
					_Detailinfos_ausblenden()
				EndIf
			EndIf
		EndIf
	EndIf



	If _WinAPI_GetAncestor(WinGetHandle("[ACTIVE]"), $GA_ROOTOWNER) = $StudioFenster Or WinGetHandle("[ACTIVE]") = $Codeausschnitt_GUI Or WinGetHandle("[ACTIVE]") = $console_GUI Or _istPluginfensteraktiv() Or AutoIt_Fenster_ist_aktiv() Then

		;If Idle Timer is over 60 secounds -> pause the project timer
		If Int($Idle_Timer) > 60000 Then
			_Projekt_timer_Pausieren()
		Else
			_Projekt_Timer_fortsetzen()
		EndIf


		;Re-Register the hotkey hook if the isn app gets active again
		If $ISN_Hotkey_Hook_aktiv = 0 Then
			$ISN_Hotkey_Hook_aktiv = 1
			_EasyHotKey_Resume()
			_check_if_file_was_modified_external()
		EndIf



		;If there is no tab opened, show the isn logo on the tabpage
		If _GUICtrlTab_GetItemCount($htab) = 0 Then
			If BitAND(GUICtrlGetState($HD_Logo), $GUI_HIDE) = $GUI_HIDE Then
				_ISN_QuickSearchBar_Set_State("hide")
				_ISN_Undocked_Tab_Info_Set_State("hide")
				_HIDE_FENSTER_RECHTS("true")
				_HIDE_FENSTER_UNTEN("true")
				_Repos_HD_Logo()
				If Not BitAND(GUICtrlGetState($Splitter_DualEditor), $GUI_HIDE) Then GUICtrlSetState($Splitter_DualEditor, $GUI_HIDE)
				GUICtrlSetState($HD_Logo, $GUI_SHOW)
				_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Switch_Tab", "-1")
			EndIf
		Else
			If BitAND(GUICtrlGetState($HD_Logo), $GUI_SHOW) = $GUI_SHOW Then GUICtrlSetState($HD_Logo, $GUI_HIDE)
		EndIf
		
	Else
		;The isn app is not active anymore
		_Projekt_timer_Pausieren()
		_Colour_Calltipp_Set_State("hide")
		;Unregisters the hotkey hook, when the isn app is not active. (Prevents hotkey problems with other apps)
		If $ISN_Hotkey_Hook_aktiv = 1 Then
			$ISN_Hotkey_Hook_aktiv = 0
			_EasyHotKey_Pause()
		EndIf
	EndIf

	; Avoid high CPU usage
	Sleep(50)

WEnd

